<?php


use App\Http\Controllers\ServiceController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashBoardController;
use App\Http\Controllers\InventoryController;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TerminalController;
use App\Http\Controllers\FinanceController;
use App\Http\Controllers\OperationsController;
use App\Http\Controllers\PeopleController;
use App\Http\Controllers\FeeController;
use App\Http\Controllers\registrationController;
use App\Http\Controllers\BusinessAdvanceController; // Import
use Inertia\Inertia;


Route::get('/', function () {
    return Inertia::render('Welcome', [
        'canLogin' => Route::has('login'),
        'canRegister' => Route::has('register'),
        'laravelVersion' => Application::VERSION,
        'phpVersion' => PHP_VERSION,
    ]);
});

//Route::get('/dashboard', function () {
//    return Inertia::render('Dashboard');
//})->middleware(['auth', 'verified'])->name('dashboard');


Route::middleware(['auth'])->group(function () {
    // --- SINGLE BRAIN ---
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    // --- INVENTORY ---
    Route::post('/products', [InventoryController::class, 'store']);
    Route::delete('/products/{id}', [InventoryController::class, 'destroy']);
    Route::post('/stock', [InventoryController::class, 'storeStock']);
    Route::post('/attributes', [InventoryController::class, 'storeAttribute']);
    // PO Routes
    Route::post('/purchase-orders', [InventoryController::class, 'storePurchaseOrder']);
    Route::post('/purchase-orders/{id}/receive', [InventoryController::class, 'receivePurchaseOrder']);
    Route::post('/purchase-orders/{id}/receive', [InventoryController::class, 'receivePurchaseOrder']);

    // --- SALES TERMINAL ---
    Route::post('/sales/store', [TerminalController::class, 'storeSale']);
    Route::post('/bookings', [TerminalController::class, 'storeBooking']);
    Route::post('/bookings/fulfill', [TerminalController::class, 'fulfillBooking']);
    Route::post('/payments', [TerminalController::class, 'storePayment']);

    // --- FINANCE ---
    Route::post('/expenses', [FinanceController::class, 'storeExpense']);
    Route::post('/capital', [FinanceController::class, 'storeCapital']);
    Route::post('/accounts', [FinanceController::class, 'storeAccount']);
    Route::post('/accounts/transfer', [FinanceController::class, 'transferFunds']);
    Route::post('/fees/dispatch', [FinanceController::class, 'dispatchFeeBatch']);

    // --- OPERATIONS ---
    Route::post('/registrations', [RegistrationController::class, 'store'])->name('registrations.store');
    Route::post('/claims', [OperationsController::class, 'storeClaim']);
    Route::post('/claims/{id}/settle', [OperationsController::class, 'settleClaim']);

    // Logistics & Transfers
    Route::post('/transfers/receive', [OperationsController::class, 'receiveTransfer'])->name('transfers.receive');
    Route::post('/transfers/issue', [OperationsController::class, 'issueTransfer'])->name('transfers.issue');



    Route::post('/exchanges', [OperationsController::class, 'storeExchange']);
    Route::post('/exchanges/{id}/settle', [OperationsController::class, 'settleExchange']);

    // --- PEOPLE ---
    Route::post('/customers', [PeopleController::class, 'storeCustomer']);
    Route::delete('/customers/{id}', [PeopleController::class, 'destroyCustomer']);
    Route::post('/suppliers', [PeopleController::class, 'storeSupplier']);
    Route::delete('/suppliers/{id}', [PeopleController::class, 'destroySupplier']);
//work shop

    // Workshops
    Route::post('/workshops', [ServiceController::class, 'storeWorkshop'])->name('workshops.store');
    Route::put('/workshops/{id}', [ServiceController::class, 'updateWorkshop'])->name('workshops.update');

    // Business Advances (B2B Loans)
    Route::get('/advances', [BusinessAdvanceController::class, 'index'])->name('advances.index');
    Route::post('/advances', [BusinessAdvanceController::class, 'store'])->name('advances.store');
    Route::post('/advances/{id}/return', [BusinessAdvanceController::class, 'update'])->name('advances.update');





    // Claims Lifecycle
    Route::post('/claims', [ServiceController::class, 'storeClaim'])->name('claims.store');
    Route::post('/claims/{id}/pay-workshop', [ServiceController::class, 'payWorkshop'])->name('claims.pay_workshop');
    Route::post('/claims/{id}/recover-supplier', [ServiceController::class, 'recoverFromSupplier'])->name('claims.recover_supplier');

//Fee
    Route::post('/fees', [FeeController::class, 'store'])->name('fees.store');
    Route::post('/fees/{id}/settle', [FeeController::class, 'settle'])->name('fees.settle');
    //endfee
    // --- SETTINGS ---
    Route::post('/settings', [SettingsController::class, 'update']);

    Route::post('/stock/{id}/modify', [InventoryController::class, 'modifyStock'])->name('stock.modify');
});




Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
