
import React, { useState } from 'react';
import { Repeat, Plus, CheckCircle2, ArrowUpRight, ArrowDownLeft, X, Building2, DollarSign, Bike, Activity } from 'lucide-react';
import { router } from '@inertiajs/react';
import { IntegratedInput, IntegratedSelect, formatCurrency, getCurrentDate } from './CommonUI.tsx';

export function DealerExchangePage({ dealerExchanges, physicalStock, products, notify }: any) {
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [formData, setFormData] = useState({ type: 'Issued', dealerName: '', exchangeValue: '', engineNumber: '' });

    const handleSave = () => {
        router.post('/exchanges', formData, {
            onSuccess: () => { 
                setIsModalOpen(false); 
                notify('Exchange Recorded'); 
                setFormData({ type: 'Issued', dealerName: '', exchangeValue: '', engineNumber: '' });
            }
        });
    };

    const settleExchange = (id: string) => {
        router.post(`/exchanges/${id}/settle`, {}, {
            onSuccess: () => notify('Exchange Settled')
        });
    };

    return (
        <div className="animate-fade-in space-y-6">
            <div className="flex justify-between items-center px-4 lg:px-0">
                <h3 className="text-lg font-bold font-heading text-slate-900 uppercase italic">Dealer Exchange</h3>
                <button onClick={() => setIsModalOpen(true)} className="px-6 py-2.5 bg-slate-900 text-white rounded-xl text-xs font-bold uppercase flex items-center gap-2 tracking-widest hover:bg-black transition-all"><Plus size={14} /> New Exchange</button>
            </div>

            <div className="bg-white rounded-3xl border border-slate-200 overflow-hidden shadow-sm mx-4 lg:mx-0">
                <table className="w-full text-left">
                    <thead className="bg-slate-50 border-b uppercase italic text-[10px] font-bold text-slate-500"><tr><th className="px-6 py-5">Dealer</th><th className="px-6 py-5">Type</th><th className="px-6 py-5 text-right">Value</th><th className="px-6 py-5 text-right">Action</th></tr></thead>
                    <tbody>
                        {dealerExchanges.map((e: any) => (
                            <tr key={e.id} className="hover:bg-slate-50">
                                <td className="px-6 py-5 font-bold text-sm uppercase">{e.dealerName}</td>
                                <td className="px-6 py-5 text-xs font-black uppercase"><span className={`px-2 py-1 rounded border ${e.type === 'Issued' ? 'bg-orange-50 border-orange-100 text-orange-600' : 'bg-blue-50 border-blue-100 text-blue-600'}`}>{e.type}</span></td>
                                <td className="px-6 py-5 text-right font-mono font-black">{formatCurrency(e.exchangeValue)}</td>
                                <td className="px-6 py-5 text-right"><button onClick={() => settleExchange(e.id)} className="text-[10px] font-black uppercase text-blue-600 hover:text-blue-800 transition-colors">Settle</button></td>
                            </tr>
                        ))}
                        {dealerExchanges.length === 0 && <tr><td colSpan={4} className="p-8 text-center text-slate-400 text-xs font-bold uppercase italic">No exchange records</td></tr>}
                    </tbody>
                </table>
            </div>

            {isModalOpen && (
                <div className="fixed inset-0 bg-slate-900/60 z-[100] flex items-center justify-center p-4 backdrop-blur-sm overflow-y-auto">
                    <div className="bg-white rounded-[2.5rem] w-full max-w-md p-10 space-y-8 shadow-2xl border border-white/20 my-auto animate-fade-in">
                        <div className="flex items-center justify-between border-b border-slate-100 pb-6"><div className="flex items-center gap-4"><div className="w-12 h-12 bg-slate-900 rounded-2xl flex items-center justify-center text-white"><Repeat size={24} /></div><div><h3 className="font-black uppercase italic text-sm tracking-widest leading-none">Exchange Log</h3></div></div><button onClick={() => setIsModalOpen(false)} className="p-2 hover:bg-slate-50 rounded-full text-slate-400"><X size={20} /></button></div>
                        <div className="space-y-5">
                            <IntegratedSelect label="Direction" value={formData.type} onChange={(e: any) => setFormData({...formData, type: e.target.value})} options={['Issued', 'Received']} icon={Activity} />
                            <IntegratedInput label="Dealer Name" value={formData.dealerName} onChange={(e: any) => setFormData({...formData, dealerName: e.target.value})} icon={Building2} />
                            <IntegratedInput label="Engine Number" value={formData.engineNumber} onChange={(e: any) => setFormData({...formData, engineNumber: e.target.value})} icon={Bike} />
                            <IntegratedInput label="Exchange Value" value={formData.exchangeValue} onChange={(e: any) => setFormData({...formData, exchangeValue: e.target.value})} icon={DollarSign} />
                        </div>
                        <button onClick={handleSave} className="w-full bg-slate-900 text-white py-4 rounded-2xl font-black uppercase text-xs tracking-widest shadow-xl hover:bg-black transition-all">Confirm Exchange</button>
                    </div>
                </div>
            )}
        </div>
    );
}
