
import React from 'react';
import {
  TrendingUp, CalendarCheck, HandCoins, History,
  ShoppingBag, ClipboardCheck, ClipboardList, Zap, Activity, Bike,
  PieChart, Smartphone, Cpu, ShieldCheck, Globe, Terminal,
  Server, Radio, Timer, MapPin, Phone
} from 'lucide-react';
import { formatCurrency } from './CommonUI.tsx';

export function DashboardPage({ setActiveItem, user, stats, showroomSettings }: any) {
    const kpis = [
        { label: 'Revenue', value: formatCurrency(stats.totalRevenue), icon: TrendingUp, color: 'from-emerald-500 to-emerald-400', textColor: 'text-emerald-600' },
        { label: 'Profit', value: formatCurrency(stats.grossProfit), icon: PieChart, color: 'from-indigo-500 to-indigo-400', textColor: 'text-indigo-600' },
        { label: 'Cash', value: formatCurrency(stats.cashBalance), icon: HandCoins, color: 'from-blue-600 to-blue-500', textColor: 'text-blue-600' },
        { label: 'Stock', value: stats.stockCount, icon: History, color: 'from-orange-500 to-orange-400', textColor: 'text-orange-600' }
    ];
    const shortcuts = [
        { label: 'New Sale', icon: ShoppingBag, action: 'sales', color: 'bg-emerald-500' },
        { label: 'Booking', icon: CalendarCheck, action: 'bookings', color: 'bg-cyan-500' },
        { label: 'Add Stock', icon: ClipboardCheck, action: 'stock', color: 'bg-orange-500' },
        { label: 'Logs', icon: ClipboardList, action: 'audit', color: 'bg-slate-700' },
    ];

    return (
        <div className="animate-fade-in space-y-6 leading-none">
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 px-4 lg:px-0 leading-none">
                {kpis.map((kpi, idx) => {
                    const IconComp = kpi.icon;
                    return (
                        <div key={idx} className="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm hover:shadow-md transition-all group leading-none">
                            <div className="flex justify-between items-start mb-4 leading-none">
                                <div className={`w-12 h-12 rounded-xl bg-gradient-to-br ${kpi.color} text-white flex items-center justify-center shadow-lg transition-transform leading-none`}>
                                    <IconComp size={24} />
                                </div>
                                <span className={`text-[10px] font-black uppercase ${kpi.textColor} leading-none`}>Live</span>
                            </div>
                            <p className="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-2 leading-none">{kpi.label}</p>
                            <h3 className="text-2xl font-black text-slate-900 leading-none tracking-tight">{kpi.value}</h3>
                        </div>
                    );
                })}
            </div>

            <div className="bg-white p-6 rounded-2xl border border-slate-200 shadow-sm mx-4 lg:mx-0 leading-none">
                <div className="flex items-center gap-2 mb-6 leading-none">
                    <Zap size={14} className="text-cyan-500 fill-cyan-500" />
                    <h3 className="text-xs font-black uppercase tracking-widest leading-none">Quick Actions</h3>
                </div>
                <div className="grid grid-cols-2 lg:grid-cols-4 gap-4 leading-none">
                    {shortcuts.map((s, i) => {
                        const IconComp = s.icon;
                        return (
                            <button key={i} onClick={() => setActiveItem(s.action)} className="flex flex-col items-center gap-4 p-6 rounded-2xl bg-slate-50 border border-slate-100 hover:border-cyan-500 hover:bg-white hover:shadow-xl transition-all group leading-none">
                                <div className={`w-12 h-12 rounded-2xl ${s.color} text-white flex items-center justify-center shadow-lg group-hover:-translate-y-1 transition-transform leading-none`}><IconComp size={24} /></div>
                                <span className="text-[10px] font-black text-slate-500 group-hover:text-slate-900 uppercase tracking-widest leading-none">{s.label}</span>
                            </button>
                        );
                    })}
                </div>
            </div>

            <div className="grid grid-cols-1 lg:grid-cols-5 gap-4 px-4 lg:px-0 leading-none">
                {/* COMPACT DEVELOPER & SYSTEM TELEMETRY PANEL */}
                <div className="lg:col-span-3 bg-slate-950 p-6 rounded-[2rem] text-white shadow-2xl relative overflow-hidden leading-none group border border-white/5">
                    <div className="absolute inset-0 w-full h-[1px] bg-gradient-to-r from-transparent via-cyan-500/30 to-transparent top-0 animate-scan pointer-events-none z-20"></div>
                    <div className="absolute inset-0 opacity-10 bg-[radial-gradient(#1e293b_1px,transparent_1px)] [background-size:24px_24px] pointer-events-none"></div>

                    <div className="relative z-10 flex flex-col h-full justify-between gap-6">
                        <div className="flex justify-between items-start">
                            <div className="space-y-3">
                                <div className="flex items-center gap-3">
                                    <div className="relative">
                                        <div className="w-2 h-2 bg-cyan-500 rounded-full animate-ping absolute inset-0"></div>
                                        <div className="w-2 h-2 bg-cyan-500 rounded-full relative shadow-[0_0_10px_rgba(6,182,212,1)]"></div>
                                    </div>
                                    <p className="text-[8px] font-black text-cyan-400 uppercase tracking-[0.4em] leading-none">DEVELOPED BY</p>
                                </div>
                                <div className="flex items-end gap-3">
                                    <h4 className="text-3xl font-black italic uppercase leading-none tracking-tighter bg-clip-text text-transparent bg-gradient-to-b from-white via-slate-200 to-slate-500 drop-shadow-[0_0_10px_rgba(255,255,255,0.1)]">
                                        SmarTill
                                    </h4>
                                    <div className="flex flex-col gap-1 mb-0.5">
                                        <span className="px-1.5 py-0.5 bg-cyan-500 text-slate-950 text-[7px] font-black uppercase rounded tracking-widest leading-none">POS TERMINAL</span>
                                        <span className="px-1.5 py-0.5 bg-white/10 text-white text-[7px] font-black uppercase rounded tracking-widest leading-none">v3.1.2</span>
                                    </div>
                                </div>
                            </div>

                            {/* Integrated Support Hub */}
                            <div className="bg-white/5 border border-white/10 rounded-xl p-3 flex flex-col gap-1.5 items-end">
                                <p className="text-[7px] font-black text-slate-500 uppercase tracking-widest leading-none">Support Telemetry</p>
                                <div className="flex items-center gap-2">
                                    <Smartphone size={10} className="text-cyan-400" />
                                    <p className="text-xs font-black font-mono tracking-widest text-white leading-none">03194334335</p>
                                </div>
                            </div>
                        </div>

                        {/* Integrated Status Badges */}
                        <div className="flex gap-4 border-y border-white/5 py-3">
                            <div className="flex items-center gap-2">
                                <ShieldCheck size={12} className="text-emerald-400" />
                                <span className="text-[8px] font-black text-slate-300 uppercase tracking-widest">Enterprise Core</span>
                            </div>
                            <div className="w-px h-2.5 bg-white/10"></div>
                            <div className="flex items-center gap-2">
                                <Globe size={12} className="text-cyan-400" />
                                <span className="text-[8px] font-black text-slate-300 uppercase tracking-widest">Active License</span>
                            </div>
                        </div>

                        {/* Telemetry Data Grid */}
                        <div className="grid grid-cols-1 md:grid-cols-4 gap-4 pt-1">
                            <div className="space-y-2">
                                <div className="flex justify-between items-end leading-none">
                                    <p className="text-[8px] font-black text-slate-500 uppercase tracking-widest flex items-center gap-1 leading-none">
                                        <Server size={8} className="text-cyan-500"/> Nodes
                                    </p>
                                    <p className="text-[9px] font-black text-cyan-400 leading-none">12/12</p>
                                </div>
                                <div className="h-0.5 bg-white/5 rounded-full overflow-hidden leading-none">
                                    <div className="h-full bg-cyan-500 w-full shadow-[0_0_5px_rgba(6,182,212,0.8)] leading-none"></div>
                                </div>
                            </div>

                            <div className="space-y-2">
                                <div className="flex justify-between items-end leading-none">
                                    <p className="text-[8px] font-black text-slate-500 uppercase tracking-widest flex items-center gap-1 leading-none">
                                        <Radio size={8} className="text-indigo-500"/> Latency
                                    </p>
                                    <p className="text-[9px] font-black text-indigo-400 leading-none">24ms</p>
                                </div>
                                <div className="h-0.5 bg-white/5 rounded-full overflow-hidden leading-none">
                                    <div className="h-full bg-indigo-500 w-[20%] shadow-[0_0_5px_rgba(99,102,241,0.8)] leading-none"></div>
                                </div>
                            </div>

                            <div className="space-y-2">
                                <div className="flex justify-between items-end leading-none">
                                    <p className="text-[8px] font-black text-slate-500 uppercase tracking-widest flex items-center gap-1 leading-none">
                                        <Timer size={8} className="text-amber-500"/> Uptime
                                    </p>
                                    <p className="text-[9px] font-black text-amber-400 leading-none">99.9%</p>
                                </div>
                                <div className="h-0.5 bg-white/5 rounded-full overflow-hidden leading-none">
                                    <div className="h-full bg-amber-500 w-[99.9%] shadow-[0_0_5px_rgba(245,158,11,0.8)] leading-none"></div>
                                </div>
                            </div>

                            <div className="space-y-2">
                                <div className="flex justify-between items-end leading-none">
                                    <p className="text-[8px] font-black text-slate-500 uppercase tracking-widest flex items-center gap-1 leading-none">
                                        <Globe size={8} className="text-emerald-500"/> Sync
                                    </p>
                                    <p className="text-[9px] font-black text-emerald-400 leading-none">Cloud</p>
                                </div>
                                <div className="h-0.5 bg-white/5 rounded-full overflow-hidden leading-none">
                                    <div className="h-full bg-emerald-500 w-full shadow-[0_0_5px_rgba(16,185,129,0.8)] leading-none animate-pulse"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <style>{`
                        @keyframes scan {
                            0% { transform: translateY(0); opacity: 0; }
                            10% { opacity: 1; }
                            90% { opacity: 1; }
                            100% { transform: translateY(200px); opacity: 0; }
                        }
                        .animate-scan {
                            animation: scan 6s linear infinite;
                        }
                    `}</style>
                </div>

                {/* SHOWROOM IDENTITY PANEL (COMPACT) */}
                <div className="lg:col-span-2 bg-white rounded-[2rem] border-2 border-slate-900 shadow-2xl leading-none flex flex-col relative overflow-hidden group">
                    <div className="absolute top-0 right-0 w-32 h-32 bg-slate-950 rounded-bl-[100px] -mr-16 -mt-16 group-hover:bg-cyan-950 transition-all duration-500"></div>

                    <div className="p-6 flex flex-col items-center justify-center flex-1 text-center relative z-10 space-y-5">
                        <div className="relative">
                            <div className="absolute inset-0 bg-cyan-500/10 rounded-2xl blur-2xl animate-pulse group-hover:bg-cyan-500/20 transition-colors"></div>
                            <div className="w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white shadow-2xl relative border border-slate-800 transform group-hover:rotate-6 transition-transform">
                                <Bike size={28} />
                            </div>
                        </div>

                        <div className="space-y-2">
                            <p className="text-[8px] font-black text-cyan-600 uppercase tracking-[0.4em] leading-none mb-1">Registered Entity</p>
                            <h4 className="text-2xl font-black text-slate-950 font-logo uppercase leading-none tracking-tighter italic">
                                {showroomSettings.showroomName}
                            </h4>
                            <div className="h-0.5 w-10 bg-slate-900 mx-auto rounded-full mt-2"></div>
                        </div>

                        <div className="w-full pt-2">
                            <div className="flex items-center gap-4 px-6 py-4 bg-slate-50 rounded-2xl border border-slate-100 shadow-inner group-hover:border-cyan-200 transition-colors">
                                <MapPin size={18} className="text-slate-400" />
                                <div className="text-left">
                                    <p className="text-[8px] font-black text-slate-400 uppercase leading-none mb-1">Operational Address</p>
                                    <p className="text-xs font-bold text-slate-700 leading-tight uppercase line-clamp-2">{showroomSettings.address}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div className="bg-slate-50 p-3 flex items-center justify-center gap-4 border-t border-slate-100">
                        <p className="text-[7px] font-black text-slate-400 uppercase tracking-[0.2em]">Authorized Terminal Access Profile</p>
                    </div>
                </div>
            </div>
        </div>
    );
}
