
import React, { useState, useEffect, useMemo } from 'react';
import { 
  LayoutGrid, PackagePlus, Bike, CalendarCheck, ShoppingBag, 
  Wallet, ShieldAlert, ReceiptText, MoveRight, ClipboardList, 
  Gavel, BarChart3, Coins, Landmark, Truck, Users, Settings,
  Repeat, CreditCard
} from 'lucide-react';

// --- SHARED UI COMPONENTS & CONSTANTS ---
import { ROLES, Header, SidebarItem, Toast } from './CommonUI.tsx';

// --- MODULE PAGES ---
import { LoginPage } from './LoginPage.tsx';
import { DashboardPage } from './DashboardPage.tsx';
import { ProductsPage } from './ProductsPage.tsx';
import { StockPage } from './StockPage.tsx';
import { BookingsPage } from './BookingsPage.tsx';
import { TerminalPage } from './TerminalPage.tsx';
import { ExpensesPage } from './ExpensesPage.tsx';
import { SuppliersPage } from './SuppliersPage.tsx';
import { CustomersPage } from './CustomersPage.tsx';
import { CapitalPage } from './CapitalPage.tsx';
import { RegistrationPage } from './RegistrationPage.tsx';
import { BikeTransferPage } from './BikeTransferPage.tsx';
import { ClaimsPage } from './ClaimsPage.tsx';
import { FeesPage } from './FeesPage.tsx';
import { SettingsPage } from './SettingsPage.tsx';
import { ReportsPage } from './ReportsPage.tsx';
import { AccountsManagementPage } from './AccountsManagementPage.tsx';
import { DealerExchangePage } from './DealerExchangePage.tsx';
import { InstallmentsPage } from './InstallmentsPage.tsx';

// ==========================================
// ZONE 1: GLOBAL CONSTANTS (EMPTY FOR DB)
// ==========================================

const MENU_DEFINITIONS = [
    { id: 'dashboard', icon: LayoutGrid, label: 'Dashboard' },
    { id: 'products', icon: PackagePlus, label: 'Products' },
    { id: 'stock', icon: Bike, label: 'Stock' },
    { id: 'bookings', icon: CalendarCheck, label: 'Bookings' },
    { id: 'sales', icon: ShoppingBag, label: 'Sales' }, 
    { id: 'installments', icon: CreditCard, label: 'Lease' },
    { id: 'exchange', icon: Repeat, label: 'Exchanges' },
    { id: 'expenses', icon: Wallet, label: 'Expenses' },
    { id: 'claims', icon: ShieldAlert, label: 'Claims' },
    { id: 'fees', icon: ReceiptText, label: 'Fees' },
    { id: 'bike_transfer', icon: MoveRight, label: 'Transfers' },
    { id: 'registration', icon: Gavel, label: 'Registration' },
    { id: 'reports', icon: BarChart3, label: 'Reports' },
    { id: 'capital', icon: Coins, label: 'Capital' },
    { id: 'accounts', icon: Landmark, label: 'Accounts' }, 
    { id: 'suppliers', icon: Truck, label: 'Suppliers' },
    { id: 'customers', icon: Users, label: 'Customers' },
    { id: 'settings', icon: Settings, label: 'Settings' },
];

const DEFAULT_SETTINGS = {
    showroomName: 'New Showroom',
    address: '',
    phone: '',
    hiddenModules: [],
    disableEditing: false,
    disableDeleting: false
};

// ==========================================
// ZONE 2: MAIN COMPONENT
// ==========================================

export default function AppCopy() {
  const [activeItem, setActiveItem] = useState('dashboard');
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);
  const [isAuthenticated, setIsAuthenticated] = useState(false);
  const [currentUser, setCurrentUser] = useState<any>(null);
  const [allUsers, setAllUsers] = useState([]);
  const [showroomSettings, setShowroomSettings] = useState(DEFAULT_SETTINGS);

  const [makes, setMakes] = useState(['Honda', 'Yamaha', 'Suzuki']);
  const [years, setYears] = useState(['2025', '2024']);
  const [colors, setColors] = useState(['Red', 'Black']);

  const [products, setProducts] = useState([]);
  const [physicalStock, setPhysicalStock] = useState([]);
  const [purchaseOrders, setPurchaseOrders] = useState([]);
  const [customers, setCustomers] = useState([]);
  const [suppliers, setSuppliers] = useState([]);
  const [salesHistory, setSalesHistory] = useState([]);
  const [bookings, setBookings] = useState([]);
  const [dealerExchanges, setDealerExchanges] = useState([]);
  const [accounts, setAccounts] = useState([]);
  const [expenses, setExpenses] = useState([]);
  const [capital, setCapital] = useState([]);
  const [feeBatches, setFeeBatches] = useState([]);
  const [registrations, setRegistrations] = useState([]);
  const [claims, setClaims] = useState([]);
  const [workshops, setWorkshops] = useState([]);
  const [transferInventory, setTransferInventory] = useState([]);
  const [transferHistory, setTransferHistory] = useState([]);
  const [auditLogs, setAuditLogs] = useState([]);
  const [toastMessage, setToastMessage] = useState<string | null>(null);
  const [requestedReport, setRequestedReport] = useState<string | null>(null);

  const notify = (msg: string) => {
    setToastMessage(null);
    setTimeout(() => setToastMessage(msg), 10);
  };
  
  const stats = useMemo(() => ({ 
        totalRevenue: 0, 
        grossProfit: 0,
        activeBookings: 0, 
        cashBalance: 0, 
        stockCount: 0 
  }), []);

  const commonProps = { 
    products, setProducts, customers, setCustomers, suppliers, setSuppliers, accounts, setAccounts, 
    physicalStock, setPhysicalStock, purchaseOrders, setPurchaseOrders, salesHistory, setSalesHistory, 
    bookings, setBookings, expenses, setExpenses, capital, setCapital, registrations, setRegistrations, 
    claims, setClaims, workshops, setWorkshops, transferInventory, setTransferInventory, 
    transferHistory, setTransferHistory, dealerExchanges, setDealerExchanges, feeBatches, setFeeBatches, 
    logs: auditLogs, setLogs: setAuditLogs, user: currentUser, allUsers, setAllUsers, 
    showroomSettings, setShowroomSettings, requestedReport, setRequestedReport,
    menuDefinitions: MENU_DEFINITIONS, makes, setMakes, years, setYears, colors, setColors, stats, notify
  };

  const renderContent = () => { 
    switch(activeItem) { 
      case 'dashboard': return <DashboardPage setActiveItem={setActiveItem} user={currentUser} stats={stats} showroomSettings={showroomSettings} />; 
      default: return <DashboardPage setActiveItem={setActiveItem} user={currentUser} stats={stats} showroomSettings={showroomSettings} />; 
    } 
  };

  if (!isAuthenticated) return <LoginPage onLogin={() => setIsAuthenticated(true)} allUsers={allUsers} showroomSettings={showroomSettings} />;

  return (
    <div className="min-h-screen bg-slate-50 flex font-sans text-slate-900 leading-none">
      <nav className={`fixed top-0 left-0 bottom-0 w-[240px] bg-slate-950 flex flex-col z-[70] shadow-2xl transition-transform duration-300 ease-in-out ${isMobileMenuOpen ? 'translate-x-0' : '-translate-x-full lg:translate-x-0'}`}>
        <div className="p-6 border-b border-white/5 flex items-center gap-3 shrink-0">
            <div className="w-8 h-8 rounded-lg bg-gradient-to-br from-cyan-400 to-blue-600 flex items-center justify-center text-white"><Bike size={20} /></div>
            <div><h1 className="text-white font-bold font-logo text-sm uppercase italic">{showroomSettings.showroomName}</h1></div>
        </div>
        <div className="flex-1 p-3 space-y-0.5 overflow-y-auto custom-scrollbar">
          {MENU_DEFINITIONS.map((item) => (<SidebarItem key={item.id} item={item} isActive={activeItem === item.id} onClick={() => { setActiveItem(item.id); setIsMobileMenuOpen(false); }} />))}
        </div>
      </nav>

      <main className="flex-1 ml-0 lg:ml-[240px] transition-all duration-300 min-w-0">
        <Header title={activeItem} onMenuClick={() => setIsMobileMenuOpen(true)} user={currentUser} onLogout={() => setIsAuthenticated(false)} setActiveItem={setActiveItem} />
        <div className="p-4 lg:p-6 max-w-[1440px] mx-auto min-h-[calc(100vh-120px)]">{renderContent()}</div>
      </main>
      {toastMessage && <Toast message={toastMessage} onClose={() => setToastMessage(null)} />}
    </div>
  );
}
