
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('business_advances', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('partner_name'); // The business/person borrowing money
            $table->string('contact_info')->nullable();

            // Financials
            $table->decimal('principal_amount', 15, 2); // Amount given
            $table->decimal('agreed_return_amount', 15, 2)->nullable(); // Expected return (Principal + Profit)
            $table->decimal('returned_amount', 15, 2)->default(0); // Actual recovered so far
            $table->decimal('profit_realized', 15, 2)->default(0); // Profit booked upon return

            // Dates & Status
            $table->date('issue_date');
            $table->date('due_date')->nullable();
            $table->string('status')->default('Active'); // Active, Partial, Settled, Defaulted

            $table->text('notes')->nullable();
            $table->string('ref_number')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('business_advances');
    }
};
