<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_modifications', function (Blueprint $table) {
            $table->id();
            $table->uuid('stock_unit_id'); // Foreign key to stock_units
            $table->string('part_description'); // e.g. "Safe Guard", "Fancy Light"
            $table->decimal('cost_amount', 15, 2); // Cost added to bike
            $table->unsignedBigInteger('account_id')->nullable(); // Account paid from
            $table->string('ref_number')->nullable();
            $table->date('date');
            $table->timestamps();

            $table->foreign('stock_unit_id')->references('id')->on('stock_units')->cascadeOnDelete();
            $table->foreign('account_id')->references('id')->on('accounts')->nullOnDelete();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
