<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('registrations', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('type'); // 'Sold Unit' or 'External'
            $table->string('sale_id')->nullable();
            $table->string('customer_name')->nullable();
            $table->string('bike_info')->nullable();
            $table->string('engine_number')->nullable();
            $table->string('reg_number')->nullable();
            $table->string('agent_name')->nullable();

            // Financials
            $table->decimal('customer_fee', 15, 2)->default(0);
            $table->decimal('agent_fee', 15, 2)->default(0);
            $table->decimal('profit', 15, 2)->default(0); // Calculated

            // Lifecycle Booleans
            $table->boolean('slip_received')->default(false);
            $table->boolean('doc_received')->default(false);
            $table->boolean('doc_issued')->default(false);

            $table->date('registration_date');
            $table->string('status')->default('Applied');
            $table->text('notes')->nullable();
            $table->string('ref_number')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
