<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('transfer_logs', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // 'IN' (Receive) or 'OUT' (Issue)
            $table->string('party'); // Dealer Name, Branch, or Source
            $table->string('ref_number')->nullable();
            $table->date('date');

            // Unit Snapshot (Preserve history even if StockUnit is deleted)
            $table->string('engine_number');
            $table->string('chassis_number')->nullable();
            $table->string('details')->nullable(); // e.g. "Honda CD70 (Red)"

            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transfer_logs');
    }
};
