<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class Registration extends Model
{
    use HasUuids;

    public $incrementing = false;
    protected $keyType = 'string';

    protected $guarded = [];

    protected $casts = [
        'registration_date' => 'date',
        'slip_received' => 'boolean',
        'doc_received' => 'boolean',
        'doc_issued' => 'boolean',
        'customer_fee' => 'decimal:2',
        'agent_fee' => 'decimal:2',
        'profit' => 'decimal:2',
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
}
